/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.CraftingTaskError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.CalculationResult;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.CraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.ProcessingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.DurabilityInput;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.InfiniteInput;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Input;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Output;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.RestockableInput;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class Task {
    public static final String NBT_TASK_TYPE = "TaskType";
    public static final String NBT_PARENT_UUIDS = "ParentUuids";
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_PATTERN_STACK = "PatternStack";
    private static final String NBT_AMOUNT_NEEDED = "AmountNeeded";
    private static final String NBT_INPUTS = "Inputs";
    private static final String NBT_OUTPUTS = "Outputs";
    private static final String NBT_UUID = "Uuid";
    protected final List<Task> parents = new ObjectArrayList();
    protected final List<Input> inputs = new ObjectArrayList();
    protected final List<Output> outputs = new ObjectArrayList();
    protected final ICraftingPattern pattern;
    protected long amountNeeded;
    private UUID uuid = UUID.randomUUID();

    public Task(@Nonnull ICraftingPattern pattern, ICraftingRequestInfo requestInfo) {
        Output newOutput;
        Input newInput;
        this.pattern = pattern;
        long amountNeeded = requestInfo.getQuantity();
        for (NonNullList<ItemStack> itemStacks : pattern.getInputs()) {
            if (itemStacks.isEmpty()) continue;
            newInput = null;
            if (!pattern.isProcessing() && pattern.getByproducts().stream().anyMatch(i -> !i.func_190926_b())) {
                block1: for (Object itemStack2 : itemStacks) {
                    NonNullList matrix = NonNullList.func_191196_a();
                    for (NonNullList<ItemStack> input : pattern.getInputs()) {
                        if (input.isEmpty()) {
                            matrix.add((Object)ItemStack.field_190927_a);
                            continue;
                        }
                        ItemStack patternInputItem = (ItemStack)input.get(0);
                        if (API.instance().getComparer().isEqual(patternInputItem, (ItemStack)itemStacks.get(0))) {
                            matrix.add(itemStack2);
                            continue;
                        }
                        matrix.add((Object)patternInputItem);
                    }
                    for (ItemStack remainder : pattern.getByproducts((NonNullList<ItemStack>)matrix)) {
                        if (!API.instance().getComparer().isEqual((ItemStack)itemStack2, remainder)) continue;
                        newInput = new InfiniteInput((ItemStack)itemStack2);
                        continue block1;
                    }
                }
                ItemStack itemStack = (ItemStack)itemStacks.get(0);
                if (itemStacks.size() < 2 && newInput == null && itemStack.func_77984_f()) {
                    Object itemStack2;
                    itemStack2 = pattern.getByproducts().iterator();
                    while (itemStack2.hasNext()) {
                        Iterator remainder = (ItemStack)itemStack2.next();
                        if (!API.instance().getComparer().isEqual(itemStack, (ItemStack)remainder, 6) || remainder.func_77952_i() - 1 != itemStack.func_77952_i()) continue;
                        newInput = new DurabilityInput(itemStack, amountNeeded);
                        break;
                    }
                }
            }
            if (pattern.isProcessing()) {
                for (ItemStack inputItemStack : itemStacks) {
                    for (ItemStack output : pattern.getOutputs()) {
                        if (!API.instance().getComparer().isEqualNoQuantity(inputItemStack, output)) continue;
                        newInput = new RestockableInput(inputItemStack, (long)inputItemStack.func_190916_E());
                    }
                }
            }
            if (newInput == null) {
                newInput = new Input(itemStacks, amountNeeded);
            }
            this.mergeIntoList(newInput, this.inputs);
        }
        for (FluidStack i2 : pattern.getFluidInputs()) {
            newInput = new Input(i2, amountNeeded);
            this.mergeIntoList(newInput, this.inputs);
        }
        for (ItemStack itemStack : pattern.getOutputs()) {
            newOutput = new Output(itemStack, itemStack.func_190916_E());
            this.mergeIntoList(newOutput, this.outputs);
        }
        for (Object fluidStack : pattern.getFluidOutputs()) {
            newOutput = new Output((FluidStack)fluidStack, ((FluidStack)fluidStack).amount);
            this.mergeIntoList(newOutput, this.outputs);
        }
        Object2LongOpenHashMap restockableOutputMap = new Object2LongOpenHashMap();
        block10: for (Input input : this.inputs) {
            if (!(input instanceof RestockableInput)) continue;
            for (Output output : this.outputs) {
                if (!API.instance().getComparer().isEqualNoQuantity(output.getCompareableItemStack(), input.getCompareableItemStack())) continue;
                long remainder = output.getQuantityPerCraft() - input.getQuantityPerCraft();
                if (remainder < 0L) {
                    remainder = -remainder;
                    ((RestockableInput)input).fixCounts((int)((long)input.getQuantityPerCraft() - remainder));
                    this.mergeIntoList(new Input((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{ItemHandlerHelper.copyStackWithSize((ItemStack)input.getCompareableItemStack(), (int)((int)remainder))}), 1L), this.inputs);
                } else {
                    ((RestockableInput)input).fixCounts(input.getQuantityPerCraft());
                }
                restockableOutputMap.put((Object)output, remainder);
                continue block10;
            }
        }
        long outputStackSize = -1L;
        for (Output output : this.outputs) {
            if (output.getQuantityPerCraft() < 1) continue;
            long qpc = output.getQuantityPerCraft();
            if (restockableOutputMap.containsKey((Object)output)) {
                long actualQpc = restockableOutputMap.getLong((Object)output);
                if (actualQpc < 1L) continue;
                qpc = actualQpc;
            }
            if (requestInfo.getFluid() != null) {
                if (!API.instance().getComparer().isEqual(requestInfo.getFluid(), output.getFluidStack(), 2)) continue;
                outputStackSize = qpc;
                break;
            }
            if (!API.instance().getComparer().isEqualNoQuantity(requestInfo.getItem(), output.getCompareableItemStack())) continue;
            outputStackSize = qpc;
            break;
        }
        if (outputStackSize < 1L) {
            throw new IllegalStateException(String.format("This pattern does not seem to create the requested item!? outputStackSize: %d, requested: %s, my pattern: %s", outputStackSize, requestInfo.getFluid() != null ? requestInfo.getFluid().toString() : requestInfo.getItem().toString(), this.pattern));
        }
        this.amountNeeded = (long)Math.ceil((double)amountNeeded / (double)outputStackSize);
        for (Input input : this.inputs) {
            input.setAmountNeeded(this.amountNeeded * (long)input.getQuantityPerCraft());
        }
        for (Output output : this.outputs) {
            int qpc = output.getQuantityPerCraft();
            output.setProcessingAmount(this.amountNeeded * (long)Math.max(qpc, 1));
            output.setAmountNeeded(output.getProcessingAmount());
        }
    }

    public Task(@Nonnull INetwork network, @Nonnull NBTTagCompound compound) throws CraftingTaskReadException {
        this.uuid = compound.func_186857_a(NBT_UUID);
        this.pattern = this.readPatternFromNbt(compound.func_74775_l(NBT_PATTERN), network.world());
        this.amountNeeded = compound.func_74763_f(NBT_AMOUNT_NEEDED);
        NBTTagList inputs = compound.func_150295_c(NBT_INPUTS, 10);
        for (int i = 0; i < inputs.func_74745_c(); ++i) {
            Input newInput;
            String inputType;
            NBTTagCompound inputTag = inputs.func_150305_b(i);
            switch (inputType = inputTag.func_74779_i("InputType")) {
                case "default": {
                    newInput = new Input(inputTag);
                    break;
                }
                case "restockable": {
                    newInput = new RestockableInput(inputTag);
                    break;
                }
                case "infinite": {
                    newInput = new InfiniteInput(inputTag);
                    break;
                }
                case "durability": {
                    newInput = new DurabilityInput(inputTag);
                    break;
                }
                default: {
                    throw new CraftingTaskReadException("Unknown input type: " + inputType);
                }
            }
            this.inputs.add(newInput);
        }
        NBTTagList outputs = compound.func_150295_c(NBT_OUTPUTS, 10);
        for (int i = 0; i < outputs.func_74745_c(); ++i) {
            this.outputs.add(new Output(outputs.func_150305_b(i)));
        }
    }

    private NBTTagCompound writePatternToNbt(ICraftingPattern pattern) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_PATTERN_STACK, (NBTBase)pattern.getStack().serializeNBT());
        return tag;
    }

    private ICraftingPattern readPatternFromNbt(NBTTagCompound tag, World world) throws CraftingTaskReadException {
        ItemStack stack = new ItemStack(tag.func_74775_l(NBT_PATTERN_STACK));
        if (stack.func_77973_b() instanceof ICraftingPatternProvider) {
            return ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, null);
        }
        throw new CraftingTaskReadException("Pattern stack is not a crafting pattern provider: " + stack);
    }

    public abstract int update(@Nonnull INetwork var1, @Nonnull ICraftingPatternContainer var2, int var3);

    @Nonnull
    public abstract List<ICraftingMonitorElement> getCraftingMonitorElements();

    @Nonnull
    public abstract List<ItemStack> getLooseItemStacks();

    @Nonnull
    public List<FluidStack> getLooseFluidStacks() {
        return Collections.emptyList();
    }

    @Nonnull
    public abstract String getTaskType();

    public abstract boolean isFinished();

    protected void supplyInput(ItemStack stack) {
        if (!this.isFinished()) {
            for (Input input : this.inputs) {
                input.decreaseToCraftAmount(stack);
                if (!stack.func_190926_b()) continue;
                return;
            }
        }
    }

    protected void supplyInput(FluidStack stack) {
        if (!this.isFinished()) {
            for (Input input : this.inputs) {
                input.decreaseToCraftAmount(stack);
                if (stack.amount >= 1) continue;
                return;
            }
        }
    }

    private void mergeIntoList(Input input, List<Input> list) {
        boolean merged = false;
        for (Input output : list) {
            if (!input.equals(output)) continue;
            output.merge(input);
            merged = true;
        }
        if (!merged) {
            list.add(input);
        }
    }

    @Nonnull
    public CalculationResult calculate(@Nonnull INetwork network, @Nonnull List<ItemStack> infiniteInputs, @Nonnull HashSet<ICraftingPattern> recursedPatterns, long calculationTimeStart) {
        if (System.currentTimeMillis() - calculationTimeStart > (long)RS.INSTANCE.config.calculationTimeoutMs) {
            return new CalculationResult(new CraftingTaskError());
        }
        CalculationResult result = new CalculationResult();
        block0: for (Input input : this.inputs) {
            FluidStack missing;
            if (input instanceof InfiniteInput) {
                boolean exists = false;
                for (ItemStack infiniteInput : infiniteInputs) {
                    if (!API.instance().getComparer().isEqual(infiniteInput, input.getCompareableItemStack())) continue;
                    input.increaseItemStackAmount(input.getCompareableItemStack(), 1L);
                    exists = true;
                    break;
                }
                if (!exists) {
                    infiniteInputs.add(input.getCompareableItemStack());
                }
            }
            if (input.getAmountMissing() < 1L) continue;
            if (!input.isFluid()) {
                if (input instanceof DurabilityInput) {
                    DurabilityInput durabilityInput = (DurabilityInput)input;
                    StackListResult<ItemStack> extracted = network.extractItem(durabilityInput.getCompareableItemStack(), 1L, 2, Action.PERFORM);
                    while (extracted != null) {
                        durabilityInput.addDamageableItemStack(extracted.getFixedStack());
                        if (input.getAmountMissing() > 0L) {
                            extracted = network.extractItem(durabilityInput.getCompareableItemStack(), 1L, 2, Action.PERFORM);
                            continue;
                        }
                        break;
                    }
                } else {
                    for (ItemStack ingredient : input.getItemStacks()) {
                        StackListResult<ItemStack> extracted = network.extractItem(ingredient, input.getAmountMissing(), Action.PERFORM);
                        if (extracted == null) continue;
                        long remainder = input.increaseItemStackAmount(ingredient, extracted.getCount());
                        if (input instanceof InfiniteInput) {
                            ((InfiniteInput)input).setContainsItem(true);
                        }
                        if (remainder == -1L) continue;
                        if (remainder == 0L) continue block0;
                        network.insertItem(ingredient, remainder, Action.PERFORM);
                        continue block0;
                    }
                }
            } else {
                long remainder;
                StackListResult<FluidStack> extracted = network.extractFluid(input.getFluidStack(), input.getAmountMissing(), Action.PERFORM);
                if (extracted != null && (remainder = input.increaseFluidStackAmount(extracted.getCount())) != -1L) {
                    if (remainder == 0L) continue;
                    network.insertFluid(input.getFluidStack(), remainder, Action.PERFORM);
                    continue;
                }
            }
            if (input.getAmountMissing() > 0L) {
                ICraftingRequestInfo requestInfo;
                ICraftingPattern pattern;
                if (!input.isFluid()) {
                    pattern = network.getCraftingManager().getPattern(input.getCompareableItemStack(), p -> !p.equals(this.pattern));
                    requestInfo = API.instance().createCraftingRequestInfo(input.getCompareableItemStack(), input.getAmountMissing());
                } else {
                    pattern = network.getCraftingManager().getPattern(input.getFluidStack(), p -> !p.equals(this.pattern));
                    requestInfo = API.instance().createCraftingRequestInfo(input.getFluidStack(), input.getAmountMissing());
                }
                if (pattern != null && pattern.isValid() && !recursedPatterns.contains(pattern)) {
                    Task newTask = pattern.isProcessing() ? new ProcessingTask(pattern, requestInfo) : new CraftingTask(pattern, requestInfo);
                    HashSet recursedPatternsCopy = (HashSet)recursedPatterns.clone();
                    recursedPatternsCopy.add(pattern);
                    CalculationResult newTaskResult = newTask.calculate(network, infiniteInputs, recursedPatternsCopy, calculationTimeStart);
                    if (newTaskResult.getError() != null) {
                        return newTaskResult;
                    }
                    input.increaseToCraftAmount(input.getAmountMissing());
                    newTask.addParent(this);
                    result.getNewTasks().add(newTask);
                    result.merge(newTaskResult);
                }
            }
            if (input.getAmountMissing() <= 0L) continue;
            if (!input.isFluid()) {
                missing = input.getCompareableItemStack().func_77946_l();
                result.getMissingItemStacks().add((ItemStack)missing, input.getAmountMissing());
                continue;
            }
            missing = input.getFluidStack();
            result.getMissingFluidStacks().add(missing, input.getAmountMissing());
        }
        return result;
    }

    @Nonnull
    public NBTTagCompound writeToNbt(@Nonnull NBTTagCompound compound) {
        compound.func_186854_a(NBT_UUID, this.uuid);
        compound.func_74778_a(NBT_TASK_TYPE, this.getTaskType());
        compound.func_74782_a(NBT_PATTERN, (NBTBase)this.writePatternToNbt(this.pattern));
        compound.func_74772_a(NBT_AMOUNT_NEEDED, this.amountNeeded);
        NBTTagList inputs = new NBTTagList();
        for (Input input : this.inputs) {
            NBTTagCompound inputTag = new NBTTagCompound();
            inputTag.func_74778_a("InputType", input.getType());
            inputs.func_74742_a((NBTBase)input.writeToNbt(inputTag));
        }
        compound.func_74782_a(NBT_INPUTS, (NBTBase)inputs);
        NBTTagList outputs = new NBTTagList();
        for (Output output : this.outputs) {
            outputs.func_74742_a((NBTBase)output.writeToNbt(new NBTTagCompound()));
        }
        compound.func_74782_a(NBT_OUTPUTS, (NBTBase)outputs);
        if (!this.parents.isEmpty()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (Task parent : this.parents) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_186854_a(NBT_UUID, parent.getUuid());
                nBTTagList.func_74742_a((NBTBase)tag);
            }
            compound.func_74782_a(NBT_PARENT_UUIDS, (NBTBase)nBTTagList);
        }
        return compound;
    }

    @Nonnull
    public UUID getUuid() {
        return this.uuid;
    }

    public void addParent(Task task) {
        this.parents.add(task);
    }

    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    public List<Task> getParents() {
        return this.parents;
    }

    public List<Input> getInputs() {
        return this.inputs;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public long getAmountNeeded() {
        return this.amountNeeded;
    }
}

